/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.persistencia;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.ArchivoTemporalAnexo;
import ec.gob.sri.dimm.api.modelo.persistencia.util.DIMMObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AdministradorPersistencia<T extends RaizModelo> {
    private String informante;
    private String anio;
    private String periodo;

    public AdministradorPersistencia() {
        this.informante = null;
        this.anio = null;
        this.periodo = null;
    }

    public AdministradorPersistencia(String informante, String anio, String periodo) {
        this.informante = informante;
        this.anio = anio;
        this.periodo = periodo;
    }

    public String getInformante() {
        return this.informante;
    }

    public void setInformante(String informante) {
        this.informante = informante;
    }

    public String getAnio() {
        return this.anio;
    }

    public void setAnio(String anio) {
        this.anio = anio;
    }

    public String getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
    }

    public void serializarObjeto(T objeto) {
        this.serializarObjeto(objeto.getCodigoOperativo(), objeto);
    }

    public void serializarObjeto(String codigoOperativo, T objeto) {
        String rutaArchivoDestino = this.obtenerRutaArchivoBinario(codigoOperativo);
        this.serializarObjeto(objeto, rutaArchivoDestino);
    }

    public void serializarObjeto(T objeto, String rutaArchivo) {
        ObjectOutputStream salida = null;
        try {
            try {
                salida = new ObjectOutputStream(new FileOutputStream(rutaArchivo));
                salida.writeObject(objeto);
                salida.flush();
            }
            catch (FileNotFoundException e) {
                PluginLogger.logError("No se encontro el archivo.", "ec.gob.sri.dimm.api", e);
                try {
                    if (salida != null) {
                        salida.close();
                    }
                }
                catch (IOException e2) {
                    PluginLogger.logError("Error al cerrar el stream de salida.", "ec.gob.sri.dimm.api", e2);
                }
            }
            catch (IOException e) {
                PluginLogger.logError("Error al escribir el archivo.", "ec.gob.sri.dimm.api", e);
                try {
                    if (salida != null) {
                        salida.close();
                    }
                }
                catch (IOException e3) {
                    PluginLogger.logError("Error al cerrar el stream de salida.", "ec.gob.sri.dimm.api", e3);
                }
            }
        }
        finally {
            try {
                if (salida != null) {
                    salida.close();
                }
            }
            catch (IOException e) {
                PluginLogger.logError("Error al cerrar el stream de salida.", "ec.gob.sri.dimm.api", e);
            }
        }
    }

    public T desSerializarObjeto(ArchivoTemporalAnexo archivo, Class<T> claseObjeto) {
        return this.desSerializarObjeto(archivo.getArchivo().getAbsolutePath(), claseObjeto);
    }

    /*
     * Loose catch block
     */
    public T desSerializarObjeto(String rutaArchivoOrigen, Class<T> claseObjeto) {
        RaizModelo objeto;
        block23: {
            ObjectInputStream entrada = null;
            objeto = null;
            try {
                entrada = new DIMMObjectInputStream(claseObjeto.getClassLoader(), new FileInputStream(rutaArchivoOrigen));
                objeto = (RaizModelo)entrada.readObject();
            }
            catch (FileNotFoundException e) {
                PluginLogger.logError("No se encontro el archivo.", "ec.gob.sri.dimm.api", e);
                try {
                    if (entrada != null) {
                        entrada.close();
                    }
                    break block23;
                }
                catch (IOException e2) {
                    PluginLogger.logError("Error al cerrar el stream de entrada.", "ec.gob.sri.dimm.api", e2);
                }
                break block23;
            }
            catch (IOException e) {
                PluginLogger.logError("Error al leer el archivo.", "ec.gob.sri.dimm.api", e);
                break block23;
            }
            catch (ClassNotFoundException e) {
                PluginLogger.logError("No se encontro la clase a deserializar.", "ec.gob.sri.dimm.api", e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (entrada != null) {
                        entrada.close();
                    }
                    break block23;
                }
                catch (IOException e3) {
                    PluginLogger.logError("Error al cerrar el stream de entrada.", "ec.gob.sri.dimm.api", e3);
                }
                break block23;
            }
            {
                finally {
                    try {
                        if (entrada != null) {
                            entrada.close();
                        }
                    }
                    catch (IOException e) {
                        PluginLogger.logError("Error al cerrar el stream de entrada.", "ec.gob.sri.dimm.api", e);
                    }
                }
            }
            try {
                if (entrada != null) {
                    entrada.close();
                }
            }
            catch (IOException e) {
                PluginLogger.logError("Error al cerrar el stream de entrada.", "ec.gob.sri.dimm.api", e);
            }
        }
        return (T)objeto;
    }

    public static boolean eliminarArchivoTemporalAnexo(ArchivoTemporalAnexo descriptor) {
        File archivo = descriptor.getArchivo();
        if (archivo.exists()) {
            return archivo.delete();
        }
        return false;
    }

    public static List<ArchivoTemporalAnexo> enumerarArchivosTemporales(String codigoOperativo) {
        ArrayList<ArchivoTemporalAnexo> archivosAnexo = new ArrayList<ArchivoTemporalAnexo>();
        String rutaArchivos = AdministradorPersistencia.obtenerRutaCarpetaBinarios(codigoOperativo);
        File carpetaArchivos = new File(rutaArchivos);
        if (carpetaArchivos.isDirectory()) {
            File[] archivosBin;
            File[] fileArray = archivosBin = carpetaArchivos.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toUpperCase().endsWith(".BIN");
                }
            });
            int n = archivosBin.length;
            int n2 = 0;
            while (n2 < n) {
                File bin = fileArray[n2];
                archivosAnexo.add(new ArchivoTemporalAnexo(bin));
                ++n2;
            }
        }
        return archivosAnexo;
    }

    public String obtenerRutaArchivoBinario(String codigoOperativo) {
        return AdministradorPersistencia.obtenerRutaArchivoBinario(codigoOperativo, this.informante, this.anio, this.periodo);
    }

    public static String obtenerRutaArchivoBinario(String codigoOperativo, String informante, String anio, String periodo) {
        String rutaCompleta = AdministradorPersistencia.obtenerRutaCarpetaBinarios(codigoOperativo);
        rutaCompleta = String.format("%s%s%s$%s$%s$%s.bin", rutaCompleta, File.separator, informante, anio, periodo, codigoOperativo);
        return rutaCompleta;
    }

    private static String obtenerRutaCarpetaBinarios(String codigoOperativo) {
        String dimmDataHome = String.valueOf(File.separator) + ".dimmData";
        String dirOperativo = String.valueOf(File.separator) + "BIN_" + codigoOperativo;
        String userHome = System.getProperty("user.home");
        StringBuffer rutaCompleta = new StringBuffer(userHome).append(dimmDataHome);
        File folder = new File(rutaCompleta.toString());
        if (!folder.exists()) {
            folder.mkdir();
        }
        rutaCompleta.append(dirOperativo);
        folder = new File(rutaCompleta.toString());
        if (!folder.exists()) {
            folder.mkdir();
        }
        return rutaCompleta.toString();
    }

    public static boolean generarXML(String rutaArchivoDestino, Document document) {
        try {
            String archivoXML = AdministradorPersistencia.convertirDocumentAString(document);
            String directorio = null;
            String nombreArchivo = null;
            int val = rutaArchivoDestino.lastIndexOf(System.getProperty("file.separator"));
            directorio = rutaArchivoDestino.substring(0, val);
            nombreArchivo = rutaArchivoDestino.substring(val + 1, rutaArchivoDestino.length());
            AdministradorPersistencia.guardarArchivoXML(directorio, nombreArchivo, archivoXML);
            return true;
        }
        catch (Exception e) {
            PluginLogger.logError("Error al generar el XML.", "ec.gob.sri.dimm.api", e);
            return false;
        }
    }

    private static String convertirDocumentAString(Document document) {
        String archivoXML = null;
        try {
            DOMSource domSource = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            archivoXML = writer.toString();
        }
        catch (TransformerException ex) {
            PluginLogger.logError("Error inesperado al convertir un documento a String.", "ec.gob.sri.dimm.api", ex);
        }
        return archivoXML;
    }

    private static void guardarArchivoXML(String directorio, String nombreArchivo, String archivoXML) {
        OutputStreamWriter outStream = null;
        try {
            try {
                File archivo = new File(directorio, nombreArchivo);
                outStream = new OutputStreamWriter(new FileOutputStream(archivo));
                outStream.write(archivoXML);
            }
            catch (IOException ioe) {
                PluginLogger.logError("Error inesperado al guardar archivo XML.", "ec.gob.sri.dimm.api", ioe);
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        PluginLogger.logError("Error inesperado al cerrar OutputStreamWriter.", "ec.gob.sri.dimm.api", e);
                    }
                }
                outStream = null;
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    PluginLogger.logError("Error inesperado al cerrar OutputStreamWriter.", "ec.gob.sri.dimm.api", e);
                }
            }
            outStream = null;
        }
    }

    public static Document obtenerDocumento(String rutaArchivoOrigen) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new File(rutaArchivoOrigen));
            doc.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            PluginLogger.logError("Error al parsear el documento XML.", "ec.gob.sri.dimm.api", e);
        }
        catch (IOException e) {
            PluginLogger.logError("Error al leer el archivo XML.", "ec.gob.sri.dimm.api", e);
        }
        catch (ParserConfigurationException e) {
            PluginLogger.logError("Error en la configuraci\u00f3n del parseador XML", "ec.gob.sri.dimm.api", e);
        }
        return doc;
    }

    public static String generarRutaArchivoXMLTemporal() {
        String separadorArchivo;
        String carpetaTemporal = System.getProperty("java.io.tmpdir");
        return carpetaTemporal.endsWith(separadorArchivo = System.getProperty("file.separator")) ? String.valueOf(carpetaTemporal) + UUID.randomUUID().toString() + ".xml" : String.valueOf(carpetaTemporal) + separadorArchivo + UUID.randomUUID().toString() + ".xml";
    }
}

